<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientGiftsTable extends Migration {

	public function up()
	{
		Schema::create('client_gifts', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('from_client_id')->unsigned();
			$table->integer('to_client_id')->unsigned();
			$table->integer('order_id')->unsigned();
			$table->enum('status', array('1', '2', '3'));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('client_gifts');
	}
}