<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('client_id')->unsigned();
			$table->integer('branch_id')->unsigned();
			$table->enum('type', array('1', '2'));
			$table->double('transportation_amount')->nullable();
			$table->enum('paid', array('1', '2'));
			$table->enum('status', array('1', '2', '3'));
			$table->string('address_lat', 100)->nullable();
			$table->string('address_long', 100)->nullable();
			$table->integer('district_id')->unsigned()->nullable();
			$table->integer('coupon_id')->unsigned()->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}