<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServiceCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('service_categories', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 100);
			$table->text('note')->nullable();
			$table->timestamps();
			$table->softDeletes();
			$table->integer('service_type_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('service_categories');
	}
}