<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('clients', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('clients', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('vendors', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('vendors', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('vendors', function(Blueprint $table) {
			$table->foreign('vendor_type')->references('id')->on('clients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('vendors', function(Blueprint $table) {
			$table->foreign('package_id')->references('id')->on('clients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('vendor_images', function(Blueprint $table) {
			$table->foreign('vendor_id')->references('id')->on('vendors')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->foreign('service_category_id')->references('id')->on('service_categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('service_categories', function(Blueprint $table) {
			$table->foreign('service_type_id')->references('id')->on('service_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('service_images', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('client_points', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('client_points', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('client_points', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('district_id')->references('id')->on('districts')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('coupon_id')->references('id')->on('coupons')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('order_details', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('order_details', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('client_wallets', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('client_gifts', function(Blueprint $table) {
			$table->foreign('from_client_id')->references('id')->on('clients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('client_gifts', function(Blueprint $table) {
			$table->foreign('to_client_id')->references('id')->on('clients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('client_gifts', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('client_branch_favourites', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('client_branch_favourites', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('districts', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('carts', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('carts', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('carts', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('coupons', function(Blueprint $table) {
			$table->foreign('vendor_id')->references('id')->on('vendors')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('coupons', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('coupons', function(Blueprint $table) {
			$table->foreign('service_category_id')->references('id')->on('service_categories')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('coupons', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('branches', function(Blueprint $table) {
			$table->foreign('vendor_id')->references('id')->on('vendors')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('branches', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('branch_images', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('branch_districts', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('branch_districts', function(Blueprint $table) {
			$table->foreign('district_id')->references('id')->on('districts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('clients', function(Blueprint $table) {
			$table->dropForeign('clients_country_id_foreign');
		});
		Schema::table('clients', function(Blueprint $table) {
			$table->dropForeign('clients_city_id_foreign');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->dropForeign('cities_country_id_foreign');
		});
		Schema::table('vendors', function(Blueprint $table) {
			$table->dropForeign('vendors_country_id_foreign');
		});
		Schema::table('vendors', function(Blueprint $table) {
			$table->dropForeign('vendors_city_id_foreign');
		});
		Schema::table('vendors', function(Blueprint $table) {
			$table->dropForeign('vendors_vendor_type_foreign');
		});
		Schema::table('vendors', function(Blueprint $table) {
			$table->dropForeign('vendors_package_id_foreign');
		});
		Schema::table('vendor_images', function(Blueprint $table) {
			$table->dropForeign('vendor_images_vendor_id_foreign');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->dropForeign('services_service_category_id_foreign');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->dropForeign('services_branch_id_foreign');
		});
		Schema::table('service_categories', function(Blueprint $table) {
			$table->dropForeign('service_categories_service_type_id_foreign');
		});
		Schema::table('service_images', function(Blueprint $table) {
			$table->dropForeign('service_images_service_id_foreign');
		});
		Schema::table('client_points', function(Blueprint $table) {
			$table->dropForeign('client_points_client_id_foreign');
		});
		Schema::table('client_points', function(Blueprint $table) {
			$table->dropForeign('client_points_service_id_foreign');
		});
		Schema::table('client_points', function(Blueprint $table) {
			$table->dropForeign('client_points_order_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_client_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_branch_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_district_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_coupon_id_foreign');
		});
		Schema::table('order_details', function(Blueprint $table) {
			$table->dropForeign('order_details_order_id_foreign');
		});
		Schema::table('order_details', function(Blueprint $table) {
			$table->dropForeign('order_details_service_id_foreign');
		});
		Schema::table('client_wallets', function(Blueprint $table) {
			$table->dropForeign('client_wallets_client_id_foreign');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->dropForeign('payments_order_id_foreign');
		});
		Schema::table('client_gifts', function(Blueprint $table) {
			$table->dropForeign('client_gifts_from_client_id_foreign');
		});
		Schema::table('client_gifts', function(Blueprint $table) {
			$table->dropForeign('client_gifts_to_client_id_foreign');
		});
		Schema::table('client_gifts', function(Blueprint $table) {
			$table->dropForeign('client_gifts_order_id_foreign');
		});
		Schema::table('client_branch_favourites', function(Blueprint $table) {
			$table->dropForeign('client_branch_favourites_client_id_foreign');
		});
		Schema::table('client_branch_favourites', function(Blueprint $table) {
			$table->dropForeign('client_branch_favourites_branch_id_foreign');
		});
		Schema::table('districts', function(Blueprint $table) {
			$table->dropForeign('districts_city_id_foreign');
		});
		Schema::table('carts', function(Blueprint $table) {
			$table->dropForeign('carts_client_id_foreign');
		});
		Schema::table('carts', function(Blueprint $table) {
			$table->dropForeign('carts_branch_id_foreign');
		});
		Schema::table('carts', function(Blueprint $table) {
			$table->dropForeign('carts_service_id_foreign');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->dropForeign('rates_client_id_foreign');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->dropForeign('rates_branch_id_foreign');
		});
		Schema::table('coupons', function(Blueprint $table) {
			$table->dropForeign('coupons_vendor_id_foreign');
		});
		Schema::table('coupons', function(Blueprint $table) {
			$table->dropForeign('coupons_branch_id_foreign');
		});
		Schema::table('coupons', function(Blueprint $table) {
			$table->dropForeign('coupons_service_category_id_foreign');
		});
		Schema::table('coupons', function(Blueprint $table) {
			$table->dropForeign('coupons_service_id_foreign');
		});
		Schema::table('branches', function(Blueprint $table) {
			$table->dropForeign('branches_vendor_id_foreign');
		});
		Schema::table('branches', function(Blueprint $table) {
			$table->dropForeign('branches_city_id_foreign');
		});
		Schema::table('branch_images', function(Blueprint $table) {
			$table->dropForeign('branch_images_branch_id_foreign');
		});
		Schema::table('branch_districts', function(Blueprint $table) {
			$table->dropForeign('branch_districts_branch_id_foreign');
		});
		Schema::table('branch_districts', function(Blueprint $table) {
			$table->dropForeign('branch_districts_district_id_foreign');
		});
	}
}