<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('email');
			$table->string('username')->unique();
			$table->string('password');
			$table->integer('role_id')->unsigned();
			$table->boolean('active')->default(false);
			$table->integer('created_by')->unique()->unsigned()->nullable();
			$table->integer('deleted_by')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}