<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Message extends Eloquent {

	protected $table = 'messages';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function content()
	{
		return $this->hasOne('MessageParts');
	}

	public function type()
	{
		return $this->belongsTo('MessageType');
	}

	public function recipients()
	{
		return $this->hasMany('MessageRecipient');
	}

	public function channel()
	{
		return $this->belongsTo('MessageChannel');
	}

}