<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCampaignsTable extends Migration {

	public function up()
	{
		Schema::create('campaigns', function(Blueprint $table) {
			$table->bigIncrements('id', true)->primary();
			$table->bigInteger('account_id')->unsigned();
			$table->bigInteger('campaign_id')->unique();
			$table->string('campaign_name');
			$table->float('monthly_investment');
			$table->string('status');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('campaigns');
	}
}