<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Account extends Eloquent {

	protected $table = 'accounts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('customer_id', 'account_name', 'account_id', 'status');

	public function campaign()
	{
		return $this->hasMany('App\Models\Campaign');
	}

}