<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Order extends Eloquent {

	protected $table = 'Orders';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function invoices()
	{
		return $this->hasOne('Invoice');
	}

	public function Company()
	{
		return $this->belongsTo('Company');
	}

}