<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Orders', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('Companies')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('Invoices', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('Orders')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('Invoice_Items', function(Blueprint $table) {
			$table->foreign('invoice_id')->references('id')->on('Invoices')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Order_Items', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('Orders')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('System_Components', function(Blueprint $table) {
			$table->foreign('system_id')->references('id')->on('Systems')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('Orders', function(Blueprint $table) {
			$table->dropForeign('Orders_company_id_foreign');
		});
		Schema::table('Invoices', function(Blueprint $table) {
			$table->dropForeign('Invoices_order_id_foreign');
		});
		Schema::table('Invoice_Items', function(Blueprint $table) {
			$table->dropForeign('Invoice_Items_invoice_id_foreign');
		});
		Schema::table('Order_Items', function(Blueprint $table) {
			$table->dropForeign('Order_Items_order_id_foreign');
		});
		Schema::table('System_Components', function(Blueprint $table) {
			$table->dropForeign('System_Components_system_id_foreign');
		});
	}
}