<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Invoice extends Eloquent {

	protected $table = 'Invoices';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function invoiceItems()
	{
		return $this->hasMany('InvoiceItem');
	}

	public function order()
	{
		return $this->belongsTo('Order');
	}

}