<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRescueTable extends Migration {

	public function up()
	{
		Schema::create('rescue', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned()->index();
			$table->boolean('junior')->nullable()->default(false);
			$table->date('active')->nullable();
			$table->integer('callsign')->unsigned()->nullable();
			$table->date('division_start_date')->nullable();
			$table->date('life_member')->nullable();
			$table->text('note')->nullable();
			$table->string('positions')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('rescue');
	}
}