<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStatusTable extends Migration {

	public function up()
	{
		Schema::create('status', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('statusable_id')->unsigned();
			$table->string('statusable_type');
			$table->string('status', 60);
			$table->date('status_effective_date');
			$table->boolean('current')->default(false);
			$table->text('note')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('status');
	}
}