<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('contact_information', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('rescue', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('cascade')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('contact_information', function(Blueprint $table) {
			$table->dropForeign('contact_information_user_id_foreign');
		});
		Schema::table('rescue', function(Blueprint $table) {
			$table->dropForeign('rescue_user_id_foreign');
		});
	}
}