<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBackgroundInformationTable extends Migration {

	public function up()
	{
		Schema::create('background_information', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned()->index();
			$table->date('fingerprint_card_submitted')->nullable();
			$table->enum('background_status', array(''));
			$table->string('background_document')->nullable();
			$table->timestamp('driving_record_received')->nullable();
			$table->string('driving_record_document')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('background_information');
	}
}