<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class JotForm extends Model 
{

    protected $table = 'jot_forms';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('form_id');
    protected $visible = array('form_id');

    public function answers()
    {
        return $this->hasMany('JotFormAnswer', 'jot_form_uuid');
    }

}