<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('stocks', function(Blueprint $table) {
			$table->foreign('material_id')->references('id')->on('types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('purchases', function(Blueprint $table) {
			$table->foreign('seller_id')->references('id')->on('sellers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('purchases', function(Blueprint $table) {
			$table->foreign('unit_id')->references('id')->on('units')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('purchases', function(Blueprint $table) {
			$table->foreign('material_id')->references('id')->on('materials')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('production_stocks', function(Blueprint $table) {
			$table->foreign('stock_id')->references('id')->on('stocks')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('producttype_id')->references('id')->on('product_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('production_stock_id')->references('id')->on('production_stocks')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('materials', function(Blueprint $table) {
			$table->foreign('type_id')->references('id')->on('types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('materials', function(Blueprint $table) {
			$table->foreign('unit_id')->references('id')->on('units')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('stocks', function(Blueprint $table) {
			$table->dropForeign('stocks_material_id_foreign');
		});
		Schema::table('purchases', function(Blueprint $table) {
			$table->dropForeign('purchases_seller_id_foreign');
		});
		Schema::table('purchases', function(Blueprint $table) {
			$table->dropForeign('purchases_unit_id_foreign');
		});
		Schema::table('purchases', function(Blueprint $table) {
			$table->dropForeign('purchases_material_id_foreign');
		});
		Schema::table('production_stocks', function(Blueprint $table) {
			$table->dropForeign('production_stocks_stock_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_producttype_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_production_stock_id_foreign');
		});
		Schema::table('materials', function(Blueprint $table) {
			$table->dropForeign('materials_type_id_foreign');
		});
		Schema::table('materials', function(Blueprint $table) {
			$table->dropForeign('materials_unit_id_foreign');
		});
	}
}