<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('login_attempts', function(Blueprint $table) {
			$table->foreign('user_id')->references('user_id')->on('login_attempts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('visitor_in', function(Blueprint $table) {
			$table->foreign('id')->references('id')->on('boomt')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('vehicle_in', function(Blueprint $table) {
			$table->foreign('boomt_id')->references('id')->on('boomt')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('login_attempts', function(Blueprint $table) {
			$table->dropForeign('login_attempts_user_id_foreign');
		});
		Schema::table('visitor_in', function(Blueprint $table) {
			$table->dropForeign('visitor_in_id_foreign');
		});
		Schema::table('vehicle_in', function(Blueprint $table) {
			$table->dropForeign('vehicle_in_boomt_id_foreign');
		});
	}
}