<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateModelsTable extends Migration {

	public function up()
	{
		Schema::create('models', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('file_path');
			$table->bigInteger('project_id')->unsigned();
			$table->boolean('is_hidden')->default(1);
			$table->boolean('is_validate')->default(0);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('models');
	}
}