<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTicketsTable extends Migration {

	public function up()
	{
		Schema::create('tickets', function(Blueprint $table) {
			$table->increments('id');
			$table->string('object');
			$table->bigInteger('project_id')->unsigned();
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('ticket_type_id')->unsigned();
			$table->longText('content');
			$table->boolean('is_open')->default(0);
			$table->boolean('is_close')->default(0);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('tickets');
	}
}