<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('contact', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('files', function(Blueprint $table) {
			$table->foreign('file_type_id')->references('id')->on('files')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('files', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->foreign('project_type_id')->references('id')->on('projects_type')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('models', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('integrations', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('conversations', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('conversations_users', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('conversations_users', function(Blueprint $table) {
			$table->foreign('conversation_id')->references('id')->on('conversations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->foreign('conversation_id')->references('id')->on('conversations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tickets', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tickets', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tickets', function(Blueprint $table) {
			$table->foreign('ticket_type_id')->references('id')->on('tickets_type')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('comments_integrations', function(Blueprint $table) {
			$table->foreign('comment_id')->references('id')->on('comments')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('comments_integrations', function(Blueprint $table) {
			$table->foreign('integration_id')->references('id')->on('integrations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('comments_models', function(Blueprint $table) {
			$table->foreign('comment_id')->references('id')->on('comments')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('comments_models', function(Blueprint $table) {
			$table->foreign('model_id')->references('id')->on('models')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_company_id_foreign');
		});
		Schema::table('contact', function(Blueprint $table) {
			$table->dropForeign('contact_company_id_foreign');
		});
		Schema::table('files', function(Blueprint $table) {
			$table->dropForeign('files_file_type_id_foreign');
		});
		Schema::table('files', function(Blueprint $table) {
			$table->dropForeign('files_project_id_foreign');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->dropForeign('projects_project_type_id_foreign');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->dropForeign('projects_user_id_foreign');
		});
		Schema::table('models', function(Blueprint $table) {
			$table->dropForeign('models_project_id_foreign');
		});
		Schema::table('integrations', function(Blueprint $table) {
			$table->dropForeign('integrations_project_id_foreign');
		});
		Schema::table('conversations', function(Blueprint $table) {
			$table->dropForeign('conversations_project_id_foreign');
		});
		Schema::table('conversations_users', function(Blueprint $table) {
			$table->dropForeign('conversations_users_user_id_foreign');
		});
		Schema::table('conversations_users', function(Blueprint $table) {
			$table->dropForeign('conversations_users_conversation_id_foreign');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->dropForeign('messages_user_id_foreign');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->dropForeign('messages_conversation_id_foreign');
		});
		Schema::table('tickets', function(Blueprint $table) {
			$table->dropForeign('tickets_project_id_foreign');
		});
		Schema::table('tickets', function(Blueprint $table) {
			$table->dropForeign('tickets_user_id_foreign');
		});
		Schema::table('tickets', function(Blueprint $table) {
			$table->dropForeign('tickets_ticket_type_id_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_user_id_foreign');
		});
		Schema::table('comments_integrations', function(Blueprint $table) {
			$table->dropForeign('comments_integrations_comment_id_foreign');
		});
		Schema::table('comments_integrations', function(Blueprint $table) {
			$table->dropForeign('comments_integrations_integration_id_foreign');
		});
		Schema::table('comments_models', function(Blueprint $table) {
			$table->dropForeign('comments_models_comment_id_foreign');
		});
		Schema::table('comments_models', function(Blueprint $table) {
			$table->dropForeign('comments_models_model_id_foreign');
		});
	}
}