<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateIntegrationsTable extends Migration {

	public function up()
	{
		Schema::create('integrations', function(Blueprint $table) {
			$table->increments('id');
			$table->string('link');
			$table->boolean('is_hidden')->default(1);
			$table->boolean('is_validate')->default(0);
			$table->bigInteger('project_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('integrations');
	}
}