<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Student extends Eloquent {

	protected $table = 'students';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $guarded = array('student_id');

	public function getActivity()
	{
		return $this->hasMany('Student_activity');
	}

	public function getLogin()
	{
		return $this->hasOne('Student_login');
	}

	public function getAchievement()
	{
		return $this->hasMany('Achievements');
	}

}