<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Supervisor_activity extends Eloquent {

	protected $table = 'supervisor_activity';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function mapActivity()
	{
		return $this->hasOne('Extra_curricular_activity', 'act_id');
	}

	public function mapSupervisor()
	{
		return $this->belongsTo('Supervisor', 'sup_id');
	}

}