<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class EventGuest extends Eloquent {

	protected $table = 'event_guests';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('event_id');

	public function event()
	{
		return $this->belongsTo('App\Models\Event');
	}

	public function nationality()
	{
		return $this->belongsTo('App\Models\Nationality');
	}

}