<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEventsTable extends Migration {

	public function up()
	{
		Schema::create('events', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('subject', 64);
			$table->datetime('datetime');
			$table->string('location', 128);
			$table->integer('category_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->text('notes')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('events');
	}
}