<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateItemsTable extends Migration {

	public function up()
	{
		Schema::create('items', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 255);
			$table->text('description');
			$table->double('wholesale_price');
			$table->integer('stock');
			$table->boolean('approved');
			$table->double('operating_margin');
			$table->enum('appear_to', array('customer', 'beneficary', 'both'));
			$table->bigInteger('category_id')->unsigned();
			$table->bigInteger('vendor_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('items');
	}
}