<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 255);
			$table->string('email');
			$table->string('phone');
			$table->string('pssword');
			$table->enum('user_type', array('admin', 'supplier', 'charity_manager', 'customer', 'beneficiary', 'rider'));
			$table->enum('status', array('active', 'inactive'));
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}