<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CartItem extends Model 
{

    protected $table = 'carts_items';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function cart()
    {
        return $this->belongsTo('Cart');
    }

    public function item()
    {
        return $this->belongsTo('Product');
    }

}