<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    public function charities()
    {
        return $this->belongsToMany('Charity');
    }

    public function charity()
    {
        return $this->belongsTo('Charity');
    }

    public function vendors()
    {
        return $this->belongsToMany('Vendor');
    }

    public function orders()
    {
        return $this->hasMany('Order');
    }

    public function deliveries()
    {
        return $this->hasMany('Order');
    }

    public function reviews()
    {
        return $this->hasMany('Review');
    }

    public function wallet()
    {
        return $this->hasOne('Wallet');
    }

}