<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateShippingInvoiceProductsTable extends Migration {

	public function up()
	{
		Schema::create('shipping_invoice_products', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('shipping_invoice_id')->unsigned();
			$table->integer('shipping_invoice_category_id')->unsigned();
			$table->integer('product_id');
			$table->float('qty');
			$table->float('dosp')->nullable();
			$table->string('adosp')->nullable();
			$table->float('amz_sf')->nullable();
			$table->float('amz_ff')->nullable();
			$table->float('tdosp')->nullable();
			$table->float('tadosp')->nullable();
			$table->float('declared_value_in_yen')->nullable();
			$table->float('total_declared_value_in_yen')->nullable();
			$table->float('grand_tdosp');
			$table->float('amz_fees')->nullable();
			$table->float('grand_tasp')->nullable();
			$table->string('fosr', 255)->nullable();
			$table->string('simulator_report', 255)->nullable();
			$table->string('supporting_documents')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('shipping_invoice_products');
	}
}