<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('shipping_invoice_products', function(Blueprint $table) {
			$table->foreign('shipping_invoice_id')->references('id')->on('shipping_invoices')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('shipping_invoice_products', function(Blueprint $table) {
			$table->foreign('shipping_invoice_category_id')->references('id')->on('shipping_invoice_categories')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('shipping_invoice_status_log', function(Blueprint $table) {
			$table->foreign('shipping_invoice_product_id')->references('id')->on('shipping_invoice_products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('shipping_invoice_status_log', function(Blueprint $table) {
			$table->foreign('shipping_invoice_status_id')->references('id')->on('shipping_invoice_status')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('shipping_invoice_products', function(Blueprint $table) {
			$table->dropForeign('shipping_invoice_products_shipping_invoice_id_foreign');
		});
		Schema::table('shipping_invoice_products', function(Blueprint $table) {
			$table->dropForeign('shipping_invoice_products_shipping_invoice_category_id_foreign');
		});
		Schema::table('shipping_invoice_status_log', function(Blueprint $table) {
			$table->dropForeign('shipping_invoice_status_log_shipping_invoice_product_id_foreign');
		});
		Schema::table('shipping_invoice_status_log', function(Blueprint $table) {
			$table->dropForeign('shipping_invoice_status_log_shipping_invoice_status_id_foreign');
		});
	}
}