<?php

namespace App\Entities\Lecturers;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Booking extends Eloquent {

	protected $table = 'bookings';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('appointment', 'confirmed');

	public function lecturer()
	{
		return $this->belongsTo('Lecturer');
	}

	public function user()
	{
		return $this->belongsTo('User');
	}

}