<?php

namespace App\Entities\Users;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Notification extends Eloquent {

	protected $table = 'notifications';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('title', 'body', 'link');

	public function user()
	{
		return $this->belongsTo('User');
	}

}