<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateExtrasTable extends Migration {

	public function up()
	{
		Schema::create('extras', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title', 250);
			$table->text('description')->nullable();
			$table->decimal('price');
			$table->integer('count')->default('1');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('extras');
	}
}