<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class City extends Eloquent {

	protected $table = 'cities';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'country_id', 'status');

	public function country()
	{
		return $this->belongsTo('App\Country');
	}

	public function branches()
	{
		return $this->hasMany('App\Branch');
	}

	public function districts()
	{
		return $this->hasMany('App\District');
	}

}