<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateActivityTable extends Migration {

	public function up()
	{
		Schema::create('activity', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('event_id')->unsigned();
			$table->string('activity_name', 100);
			$table->text('description');
			$table->date('act_date');
			$table->time('act_start_time');
			$table->time('act_end_time');
			$table->boolean('registration_required');
			$table->smallInteger('maximum_attendees');
		});
	}

	public function down()
	{
		Schema::drop('activity');
	}
}