<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEventTable extends Migration {

	public function up()
	{
		Schema::create('event', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->enum('event_type', array('monthly_meeting', 'foray', 'camp', 'expo', 'epicurean'));
			$table->string('event_name', 100);
			$table->text('description');
			$table->date('start_date');
			$table->time('start_time');
			$table->date('end_date');
			$table->time('end_time');
			$table->boolean('registration_required');
			$table->boolean('member_only');
			$table->smallInteger('maximum_attendees');
		});
	}

	public function down()
	{
		Schema::drop('event');
	}
}