<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id');
			$table->integer('item_id');
			$table->double('total', 8,2);
			$table->double('discount', 8,2);
			$table->string('payment_type_id');
			$table->integer('address_id');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}