<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdminsTable extends Migration {

	public function up()
	{
		Schema::create('admins', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 255)->unique();
			$table->string('username', 255)->unique();
			$table->string('email', 255)->unique();
			$table->string('password', 255);
			$table->string('phone', 20)->unique();
			$table->string('image', 255)->default('user.png');
		});
	}

	public function down()
	{
		Schema::drop('admins');
	}
}