<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('full_name', 255);
			$table->string('email', 255)->unique();
			$table->string('password', 255);
			$table->bigInteger('account_number')->unique();
			$table->string('phone', 20)->unique();
			$table->integer('package_id')->unsigned();
			$table->string('image', 255)->default('user.png');
			$table->integer('city_id')->unsigned();
			$table->integer('country_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}