<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Users extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function created_by_user()
	{
		return $this->belongsTo('Groups', 'created_by');
	}

	public function group_user()
	{
		return $this->hasMany('GroupUser', 'user_id');
	}

	public function forumCreatedBy()
	{
		return $this->hasMany('Forums', 'created_by');
	}

}