<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Chord extends Model 
{

    protected $table = 'chords';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function artist()
    {
        return $this->hasOne('Artist', 'id');
    }

    public function album()
    {
        return $this->hasOne('Album', 'id');
    }

    public function genre()
    {
        return $this->hasOne('Genre', 'id');
    }

    public function tags()
    {
        return $this->morphToMany('Tag', 'taggable');
    }

    public function comments()
    {
        return $this->morphMany('Comment', 'commentable');
    }

    public function rates()
    {
        return $this->belongsToMany('User', 'rates');
    }

    public function likes()
    {
        return $this->belongsToMany('User', 'likes');
    }

}