<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateChordsTable extends Migration {

	public function up()
	{
		Schema::create('chords', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 200);
			$table->string('slug', 250)->unique();
			$table->integer('user_id')->unsigned();
			$table->integer('artist_id')->unsigned();
			$table->integer('album_id')->unsigned()->nullable();
			$table->integer('genre_id')->unsigned();
			$table->string('cover_img', 250)->nullable();
			$table->string('main_scale', 50)->nullable();
			$table->text('chord');
			$table->smallInteger('pub_year')->unsigned()->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('chords');
	}
}