<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEpisodesTable extends Migration {

	public function up()
	{
		Schema::create('episodes', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title', 250);
			$table->string('slug', 250)->unique();
			$table->integer('course_id')->unsigned();
			$table->boolean('is_free')->default(0);
			$table->text('short_desc');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('episodes');
	}
}