<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Course extends Eloquent {

	protected $table = 'courses';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function genre()
	{
		return $this->hasOne('Genre', 'id');
	}

	public function instrument()
	{
		return $this->hasOne('Instrument', 'id');
	}

	public function artist()
	{
		return $this->hasOne('Artist', 'id');
	}

	public function teacher()
	{
		return $this->hasOne('Teacher', 'id');
	}

	public function level()
	{
		return $this->hasOne('Level', 'id');
	}

	public function comments()
	{
		return $this->morphMany('Comment', 'commentable');
	}

	public function episodes()
	{
		return $this->hasMany('Episode', 'course_id');
	}

}