<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAlbumsTable extends Migration {

	public function up()
	{
		Schema::create('albums', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 250)->index();
			$table->string('slug', 250)->unique();
			$table->smallInteger('pub_year')->unsigned()->nullable();
			$table->integer('artist_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('albums');
	}
}