<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateArtistTable extends Migration {

	public function up()
	{
		Schema::create('artist', function(Blueprint $table) {
			$table->increments('id');
			$table->string('slug', 250)->unique();
			$table->string('name', 200)->index();
			$table->string('latin_name', 250)->nullable();
			$table->string('img', 250)->unique()->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('artist');
	}
}