<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCoursesTable extends Migration {

	public function up()
	{
		Schema::create('courses', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title', 250)->index();
			$table->string('slug', 250)->unique();
			$table->text('long_desc');
			$table->text('short_desc');
			$table->decimal('price', 6,0)->nullable()->default('0');
			$table->string('img', 250);
			$table->integer('genre_id')->unsigned();
			$table->integer('instrument_id')->unsigned();
			$table->integer('artist_id')->unsigned()->nullable();
			$table->integer('teacher_id')->unsigned();
			$table->integer('level_id')->unsigned();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('courses');
	}
}