<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBuildingsTable extends Migration {

	public function up()
	{
		Schema::create('buildings', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title')->nullable();
			$table->string('address')->nullable();
			$table->string('section')->nullable();
			$table->string('flat')->nullable();
			$table->tinyInteger('rooms')->nullable();
			$table->tinyInteger('floor')->nullable();
			$table->integer('rent_rate')->nullable();
			$table->boolean('is_bail')->default(false);
			$table->integer('bank_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('buildings');
	}
}